package context

//RuntimeLogger is a low level function stage runtime logger
type RuntimeLogger interface {
	Logf(format string, args ...interface{})
}

// RuntimeContext Interface allows you to access useful information available within
// the function stage runtime execution environment
type RuntimeContext interface {
	/*
	* Gets the request ID associated with the request.
	* <p>
	* This is the same ID returned to the client that called invoke(). This ID
	* is reused for retries on the same request.
	**/
	GetRequestID() string

	/*Gets the time remaining for this execution in milliseconds*/
	GetRemainingTimeInMilliSeconds() int

	/*Gets the AK information of the tenant*/
	GetAccessKey() string

	/*Gets the SK information of the tenant*/
	GetSecretKey() string

	/* Gets the name of the function*/
	GetFunctionName() string

	/* Gets the user data,which saved in a map */
	GetUserData(string) string

	/* Gets the logger for user to log out in standard output, The Logger interface must be provided in SDK*/
	GetLogger() RuntimeLogger

	/*
	* Gets the time distributed to the running of the function,
	* when exceed the specified time, the running of the function would be stopped by force
	**/
	GetRunningTimeInSeconds() int

	/* Get version of the running function*/
	GetVersion() string

	/*Get the memory size distributed the running function*/
	GetMemorySize() int

	/*Get the number of cpu distributed to the running function
	* the cpu number scale by millicores, one cpu cores equals 1000 millicores.
	* In function stage runtime, every function have base of 200 millicores,and increased by
	* memory size distributed to function. the offset is about Memory Size(M)/128 *100.
	**/
	GetCPUNumber() int

	/* Get Project ID of the tenant */
	GetProjectID() string
	/* Get Package of the tenant */
	GetPackage() string

	/* Get Token of the tenant */
	GetToken() string

	/* Get security token. In order to invoke interface of other service,
	*AK,SK and security token should been provided.
	**/
	GetSecurityToken() string
}
